<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Support\Facades\Config;
use Illuminate\Validation\ValidationException;

class MailConfig
{
    public function handle($request, Closure $next)
    {
        $data = @settings('mail_config');
        $emailServices = json_decode($data, true);
        if ($emailServices) {
            $config[$emailServices['driver']] = array(
                'status' => true,
                'host' => $emailServices['host'],
                'port' => $emailServices['port'],
                'username' => $emailServices['username'],
                'password' => $emailServices['password'],
                'encryption' => $emailServices['encryption'],
                'sendmail' => '/usr/sbin/sendmail -bs',
                'pretend' => false,
            );
            $from = [
                'address' => $emailServices['mail'],
                'name' => $emailServices['name']
            ];
            Config::set('mailers', $config);
            Config::set('mail.from', $from);
        }
        return $next($request);
    }

}
