<?php

namespace Modules\User\Controllers\Admin;

use App\Enum\UserType;
use App\Helpers\ApiResponse;
use App\Notifications\BlockUserNotifications;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Notification;
use Modules\Areas\Models\Area;
use Modules\Chats\Models\Chat;
use Modules\Common\Controllers\Admin\HelperController;
use Modules\Location\Models\Location;
use Modules\Playground\Models\Playground;
use Modules\User\Models\Admin;
use Modules\User\Models\User;
use Modules\User\Requests\SupervisorRequest;
use Modules\User\Requests\UserRequest;
use MshMsh\Helpers\ApiResponder;

class AdminSupervisorController extends HelperController
{
    public function __construct()
    {
        $status = request('status');
        $this->model = new User;
        $this->rows = User::when(request()->query('role_id'), fn($q) => $q->where('role_id', request()->query('role_id')))
            ->when(request()->has('status'), fn($q) => $q->where('status', request()->query('status')));

        $this->canAdd = false;
        if ($status) {
            $this->canAdd = true;
        }

        $this->title = "supervisors";
        $this->name = 'supervisors';
        $this->canShow = true;
        $this->formRequest = SupervisorRequest::class;
        $this->roleName = 'User';
        $this->queryParams['status'] = $status;
        $this->moreActions[] = 'syncActive';
    }
    public function listBuilder()
    {
        $this->list = [
            'name' => __('name'),
            'mobile' => __('mobile'),
            'email' => __('email'),
        ];

        $this->links = [
            [
                'title' => 'Notify',
                'icon' => 'fa fa-bell',
                'url' => route('admin.notifications'),
                'key' => 'user_id',
                'type' => 'secondary',
            ]
        ];


        $this->switches['status'] = route('admin.users.active_status');
    }
    public function formBuilder()
    {

        // $groups = get_select_data(UserGroup::get(), 'id', 'name');
        $areas = Area::active()->pluck('name', 'id')->toArray();
        $this->inputs = [
            'name' => ['title' => __('name')],
            'mobile' => ['title' => __('phone')],
            'email' => ['title' => __('email')],
            'playground_id[]' => ['title' => 'الملاعب', 'type' => 'select', 'multiple' => 'multiple', 'value' => $this->model->playgrounds()->pluck('playgrounds.id')->toArray(), 'values' => get_select_data(Playground::get(), 'id', 'name')],
            'area_id' => ['title' => __('area'), 'type' => 'select', 'values' => $areas],
            'image' => ['title' => __('image'), 'type' => 'image', 'empty' => 1],
        ];
    }


    public function active_status(Request $request)
    {
        $user = User::findOrFail($request->id);
        $user->update(['status' => !$user->status]);
        $user->refresh();
        if (!$user->status) {
            Notification::send($user, new BlockUserNotifications($user));
        }
        return ApiResponse::get('', ['status' => 1]);
    }

    public function syncActive($model)
    {
        if ($model->getRawOriginal('created_at') == $model->getRawOriginal('updated_at')) {
            $model->update(['status' => 1]);
        }
        $model->playgrounds()->sync(request('playground_id'));
    }

    public function show($id)
    {
        $user = User::findOrFail($id);
        $title =   __("show user");
        return view('User::admin.show', get_defined_vars());
    }
}
