<?php

namespace Modules\Payment\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Log;
use App\Http\Controllers\Controller;
use Modules\Payment\Services\WalletService;
use Modules\User\Models\User;
use Stripe\Webhook;
use Stripe\Exception\SignatureVerificationException;

class StripeWebhookController extends Controller
{
   public function handleWebhook(Request $request, WalletService $walletService)
{
 
 
    $endpoint_secret = env('STRIPE_WEBHOOK_SECRET');
    $payload = @file_get_contents('php://input');
    $sig_header = $_SERVER['HTTP_STRIPE_SIGNATURE'];
    $event = null;

    try {
        $event = \Stripe\Webhook::constructEvent(
            $payload, $sig_header, $endpoint_secret
        );
    } catch (\UnexpectedValueException $e) {
        return response()->json(['error' => 'Invalid payload'], 400);
    } catch (\Stripe\Exception\SignatureVerificationException $e) {
        return response()->json(['error' => 'Invalid signature'], 400);
    }

    // لحد هنا تمام، المشكلة بتبدأ تحت
    if ($event->type == 'checkout.session.completed') {
        
        // هنفتح قوس مراقبة للأخطاء هنا
        try {
            $session = $event->data->object;

            // 1. تسجيل الدخول للتأكد من البيانات

            // 2. طريقة آمنة لاستخراج الميتا داتا (أحيانا بتيجي كائن مش مصفوفة)
            $metadata = $session->metadata; 
            $userId = $metadata->user_id ?? null;
            $amount = $metadata->amount_paid ?? 0;
            $type = $metadata->transaction_type ?? null;


            if ($userId && $type == 'wallet_topup') {
                $user = User::find($userId);
                
                if ($user) {
                    $walletService->deposit(
                        $user, 
                        (float)$amount, 
                        'deposit', 
                        null, 
                        "Stripe Top-up: " . ($session->payment_intent ?? 'N/A')
                    );
                } else {
                }
            } 

        } catch (\Exception $e) {
            // دي أهم نقطة: هتطبع سبب الـ 500 بالظبط
            Log::error("CRITICAL ERROR inside Webhook: " . $e->getMessage());
            Log::error($e->getTraceAsString());
            return response()->json(['error' => $e->getMessage()], 500);
        }
    }

    return response()->json(['status' => 'success']);
}
}
