<?php

namespace Modules\Match\Controllers;

use App\Helpers\ApiResponse;
use App\Http\Controllers\Controller;
use App\Traits\ApiResponsee;
use Illuminate\Http\Request;
use Modules\Match\Requests\JoinMatchRequest;
use Modules\Match\Requests\StoreMatchRequest;
use Modules\Match\Requests\UpdateMatchRequest;
use Modules\Match\Resources\MatchCollection;
use Modules\Match\Resources\MatcheResource;
use Modules\Match\Services\MatchService;

class ApiController extends Controller
{
    use ApiResponsee;
    protected $matchService;

    public function __construct(MatchService $matchService)
    {
        $this->matchService = $matchService;
    }

    public function index()
    {
        $matches = $this->matchService->paginate();
        if (! $matches) {
            $errors = $this->matchService->errors();
            return $this->apiResponse(400, 'fail', $errors, null);
        }
        return ApiResponse::loaded(new MatchCollection($matches), 200, 'success');
    }

    public function store(StoreMatchRequest $request)
    {
        $match = $this->matchService->store($request->validated());
        if (!$match) {
            $errors = $this->matchService->errors();
            return $this->apiResponse(400, 'fail', $errors, null);
        }
        return ApiResponse::loaded(new MatcheResource($match), 200, 'success');
    }


    public function update(UpdateMatchRequest $request, $id)
    {
        $match = $this->matchService->update($request->validated(), $id);
        if (!$match) {
            $errors = $this->matchService->errors();

            return $this->apiResponse(400, 'fail', $errors, null);
        }
        return ApiResponse::loaded(new MatcheResource($match), 200, 'success');
    }



    public function destroy($id)
    {
        $match = $this->matchService->destroy($id);
        if (!$match) {
            $errors = $this->matchService->errors();

            return $this->apiResponse(400, 'fail', $errors, null);
        }
        return ApiResponse::loaded(new MatcheResource($match), 200, 'success');
    }

    public function show($id)
    {
        $match = $this->matchService->show($id);
        if (!$match) {
            $errors = $this->matchService->errors();

            return $this->apiResponse(400, 'fail', $errors, null);
        }
        return ApiResponse::loaded(new MatcheResource($match), 200, 'success');
    }


    public function upcommingmatches($playground_id)
    {
        $matches = $this->matchService->upcommingmatches($playground_id);
        if (!$matches) {
            $errors = $this->matchService->errors();

            return $this->apiResponse(400, 'fail', $errors, null);
        }

        return ApiResponse::loaded(new MatchCollection($matches), 200, 'success');
    }




    public function join(JoinMatchRequest $request)
    {

        $match = $this->matchService->joinMatch($request->match_id, $request->team_side);
        if (!$match) {

            $errors = $this->matchService->errors();
            return $this->apiResponse(400, 'fail', $errors, null);
        }

        
        $match->load('playground', 'user', 'teamPlayers.location');
        $match->loadCount([
            'teamPlayers',
            'teamPlayers as white_team_players_count' => function ($query) {
                $query->where('team_side', 'White');
            },
            'teamPlayers as dark_team_players_count' => function ($query) {
                $query->where('team_side', 'Dark');
            }
        ]);

        return ApiResponse::loaded(new MatcheResource($match), 200, __('messages.Joined match successfully'));
    }




    public function nearest()
    {
        $request = request();
        $request->validate([
            'lat' => 'required|numeric',
            'lng' => 'required|numeric',
        ]);

        $matches = $this->matchService->getNearest($request->query('lat'), $request->query('lng'));

        if ($matches->isEmpty()) {
            $errors = $this->matchService->errors();

            return $this->apiResponse(400, 'fail', $errors, null);
        }

        return ApiResponse::loaded(MatcheResource::collection($matches), 200, 'success');
    }
}
