@extends('Common::admin.layout.page')
@section('page')
    <!-- Small boxes (Stat box) -->
    <div class="row">
        @foreach ($counters as $count)
            <div class="col-lg-3 col-6">
                <!-- small box -->
                <div class="small-box text-white bg-{{ $count['type'] }}">
                    <div class="inner">
                        <h3>{{ $count['count'] }}</h3>

                        <p>{{ $count['title'] }}</p>
                    </div>
                    <div class="icon">
                        <i class="ion fas {{ $count['icon'] }}"></i>
                    </div>
                    <a href="{{ $count['url'] }}" style="color:white !important;" class="small-box-footer mlink">@lang('More') <i
                            class="fas fa-arrow-circle-right"></i></a>
                </div>
            </div>
            <!-- ./col -->
        @endforeach
    </div>
    <div class="row">
        <div class="col-md-6">
            <div class="card">
                <div class="card-header">
                    <h6 class="m-0 font-weight-bold text-primary">{{__('Last Clients')}}</h6>
                </div>
                <div class="card-content">
                    <div class="table-responsive mt-1">
                        <table class="table table-hover-animation mb-0">
                            <thead>
                            <tr>
                                <th>{{__('ID')}}</th>
                                <th>{{__('name')}}</th>
                                <th>{{__('phone')}}</th>
                                <th>{{__('image')}}</th>
                                <th>{{__('Created At')}}</th>
                            </tr>
                            </thead>
                            <tbody>
                            @if(count($users) > 0)
                                @foreach($users as $user)
                                    <tr>
                                        <td>{{$user->id}}</td>
                                        <td>{{$user->name}}</td>
                                        <td>{{@$user->mobile}}</td>
                                        <td>
                                            <img class="media-object rounded-circle" src="{{$user->image}}" alt="Avatar" height="50" width="50">
                                        </td>
                                        <td>{{date('Y-m-d',strtotime($user->created_at))}}</td>
                                    </tr>
                                @endforeach
                            @else
                                <tr>
                                    <td colspan="5" class="text-center">{{__('No Data')}}</td>
                                </tr>
                            @endif
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
