<?php

namespace Modules\Payment\Gateways;

use Modules\Payment\Interfaces\PaymentGatewayInterface;
use Stripe\Stripe;
use Stripe\Checkout\Session;

class StripeGateway implements PaymentGatewayInterface
{
    public function __construct()
    {
        Stripe::setApiKey(env('STRIPE_SECRET'));
    }

    public function charge($amount, $user, $metadata = [])
    {
        $session = Session::create([
            'payment_method_types' => ['card'],
            'customer_email' => $user->email,
            'line_items' => [[
                'price_data' => [
                    'currency' => 'usd',
                    'product_data' => [
                        'name' => 'Charge Your Wallet ',
                    ],
                    'unit_amount' => $amount * 100,
                ],
                'quantity' => 1,
            ]],
            'mode' => 'payment',
            'success_url' => route('payment.success'),
            'cancel_url' => route('payment.cancel'),
            'metadata' => array_merge([
                'user_id' => $user->id,
                'transaction_type' => 'wallet_topup',
                'amount_paid' => $amount
            ], $metadata),
        ]);

        return $session->url;
    }

public function success()
{
    return "You Successfully Paid";
}

public function cancel()
{
    return "You Canceled The Payment";
}

}
