<?php

namespace Modules\Match\Notifications;

use App\Notifications\Channels\FcmChannel;
use App\Support\Actions\FCMAction;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Notifications\Notification;

class PlayerJoinedMatchNotification extends Notification implements ShouldQueue
{
    use Queueable;

    protected $match;
    protected $player;
    protected $data;

    public function __construct($match, $player)
    {
        $this->match = $match;
        $this->player = $player;

        $this->data = [
            'title' => __('Player Joined Match'),
            'body' => __(':player has joined your match :match', ['player' => $this->player->name, 'match' => $this->match->name]),
            'match_id' => $this->match->id,
            'player_id' => $this->player->id,
            'type' => 'player_joined_match'
        ];
    }

    public function via($notifiable)
    {
        return ['database', FcmChannel::class];
    }

    public function toArray($notifiable)
    {
        return $this->data;
    }

    public function toFcm($notifiable)
    {
        FCMAction::new($notifiable)->withData($this->data)
            ->withTitle($this->data['title'])
            ->withBody($this->data['body'])
            ->sendMessage('tokens');
    }
}
