<?php

namespace App\Support\Api;

use JetBrains\PhpStorm\NoReturn;

trait ApiResponseTrait
{
    use ApiData ;
    protected   int $status_code = 400;

    protected  $data = null;

    protected  $pagination = null ;

    protected  array $response = [];

    protected string $message = '';

    protected string $info = 'from response action';

    public function apiResponse(): \Illuminate\Http\JsonResponse
    {

        // Set the status based on the status code.
        $this->response['status'] =  ($this->status_code == 200 ) ? true : false ;
        // Set the message.
        $this->response['message'] =  $this->message ;
        // Set the data.
        $this->response['data'] =  $this->data ;
        // Set the info if it exists.
        if ($this->info){
            $this->response['info'] =  $this->info ;
        }
        // Set the pagination if it exists.
        if($this->pagination){
            $this->response['pagination'] = $this->pagination ?? null;
        }
        // Generate the JSON response and return it.
        return response()->json($this->response, $this->status_code);
    }

    /**
     * Set the API status code.
     *
     * @param int $code The status code to set.
     * @return void
     */
    protected function apiCode(int $code = 400): void
    {
        $this->status_code = $code;
    }
    protected function apiMessage(string $message = ''): void
    {
        $this->message = $message;
    }
    protected function apiInfo(string $info = '', $addToCurrent = true): void
    {
       $addToCurrent ? $this->info .= $info : $this->info = $info;


    }
}
