<?php

namespace App\Console\Commands;

use App\Notifications\MatchNotifications;
use Carbon\Carbon;
use Illuminate\Console\Command;
use Illuminate\Support\Facades\Notification;
use Modules\Match\Models\Matche;

class SendMatchReminders extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'notify:match-reminders';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Send match reminders 30, 15, and 5 minutes before start';

    /**
     * Execute the console command.
     */
    public function handle()
    {
        $this->sendReminders(30);
        $this->sendReminders(15);
        $this->sendReminders(5);
    }

    private function sendReminders($minutes)
    {
        $targetTime = Carbon::now()->addMinutes($minutes)->format('H:i') . ':00';
        $this->info("Checking for matches starting at: $targetTime ({$minutes} mins from now)");

        $matches = Matche::whereDate('date', Carbon::now()->format('Y-m-d'))
            ->whereTime('start_time', $targetTime)
            ->active()
            ->with(['teamPlayers', 'playground'])
            ->get();

        if ($matches->isEmpty()) {
            $this->info("No matches found for {$minutes} min reminder.");
            return;
        }

        foreach ($matches as $match) {
            $message = 'Reminder For Match ' . @$match->playground?->name . ' will start in ' . $minutes . ' minutes';
            $players = $match->teamPlayers->filter(function ($user) {
                return $user->wantsNotification('Match Start Reminders');
            });

            if ($players->count() > 0) {
                Notification::send($players, new MatchNotifications($match, $message));
                $this->info("Sent {$minutes} min reminder for match ID: {$match->id}");
            } else {
                $this->info("Match ID: {$match->id} has no players or none enabled reminders.");
            }
        }
    }
}
