<?php

namespace Modules\Reviews\Requests;

use Illuminate\Foundation\Http\FormRequest;

class UpdateReviewRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            'user_id' => 'exists:users,id',
            'rating' => 'sometimes|integer|between:1,10',
            'comment' => 'sometimes|nullable|string',
            'reviewable_id' => 'sometimes|integer',
            'reviewable_type' => 'sometimes|string',
        ];
    }
}
