<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('wallets', function (Blueprint $table) {
            $table->id();
            $table->foreignId('user_id')->constrained()->onDelete('cascade');
            $table->decimal('balance', 12, 2)->default(0); // دايما استخدم decimal للفلوس
            $table->string('currency')->default('USD');
            $table->timestamps();
        });

        Schema::create('wallet_transactions', function (Blueprint $table) {
            $table->id();
            $table->foreignId('wallet_id')->constrained()->onDelete('cascade');
            $table->enum('type', ['deposit', 'withdrawal', 'payment', 'refund']);
            $table->decimal('amount', 12, 2); // المبلغ (سالب للخصم، موجب للإضافة)
            $table->decimal('balance_after', 12, 2); // رصيد المحفظة بعد الحركة دي (مهم جدا للمراجعة)

            // Polymorphic: عشان نربط الحركة بـ (ماتش، طلب سحب، أو عملية دفع خارجية)
            $table->nullableMorphs('reference'); // بيعمل reference_id و reference_type

            $table->string('description')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('wallet_transactions');
        Schema::dropIfExists('wallets');
    }
};
